<?php
class Ad { const TYPE_BANNER = 'banner'; const TYPE_POPUP = 'popup'; const TYPE_MISLEADING = 'misleading'; const STATUS_PENDING = 0; const STATUS_ACCEPTED = 1; const STATUS_REJECTED = 2; const STATUS_COMPLETED = 3; const STATUS_CANCELLED = 4; private $id; private $name; private $description; private $type; private $impressionCount; private $creditPerImpression; private $completionMonths; private $startYear; private $startMonth; private $endYear; private $endMonth; private $isAccepted; private $currentImpressions; private $visitorSatisfactionEffect; private $createdAt; private $expiresAt; private $totalCredit; public function __construct($data) { $this->id = $data['id'] ?? null; $this->name = $data['name']; $this->description = $data['description']; $this->type = $data['type']; $this->impressionCount = $data['impression_count']; $this->creditPerImpression = $data['credit_per_impression']; $this->completionMonths = $data['completion_months']; $this->startYear = $data['start_year'] ?? null; $this->startMonth = $data['start_month'] ?? null; $this->endYear = $data['end_year'] ?? null; $this->endMonth = $data['end_month'] ?? null; $this->isAccepted = $data['is_accepted'] ?? self::STATUS_PENDING; $this->currentImpressions = $data['current_impressions'] ?? 0; $this->visitorSatisfactionEffect = $data['visitor_satisfaction_effect'] ?? $this->getDefaultSatisfactionEffect(); $this->createdAt = $data['created_at'] ?? null; $this->expiresAt = $data['expires_at'] ?? null; $this->totalCredit = $data['total_credit'] ?? ($this->impressionCount * $this->creditPerImpression); } private function getDefaultSatisfactionEffect() { switch ($this->type) { case self::TYPE_BANNER: return -1 * (mt_rand(10, 30) / 1000); case self::TYPE_POPUP: return -1 * (mt_rand(40, 70) / 1000); case self::TYPE_MISLEADING: return -1 * (mt_rand(120, 180) / 1000); default: return 0.0; } } public function getId() { return $this->id; } public function getName() { return $this->name; } public function getDescription() { return $this->description; } public function getType() { return $this->type; } public function getImpressionCount() { return $this->impressionCount; } public function getCreditPerImpression() { return $this->creditPerImpression; } public function getTotalCredit() { return $this->totalCredit; } public function getCompletionMonths() { return $this->completionMonths; } public function getStartYear() { return $this->startYear; } public function getStartMonth() { return $this->startMonth; } public function getEndYear() { return $this->endYear; } public function getEndMonth() { return $this->endMonth; } public function getStatus() { return $this->isAccepted; } public function getCurrentImpressions() { return $this->currentImpressions; } public function getVisitorSatisfactionEffect() { return $this->visitorSatisfactionEffect; } public function getCompletionPercentage() { if ($this->impressionCount == 0) return 0; return ($this->currentImpressions / $this->impressionCount) * 100; } public function getCreatedAt() { return $this->createdAt; } public function getExpiresAt() { return $this->expiresAt; } public function getRemainingTimeMinutes() { if (!$this->expiresAt || !$this->createdAt) { return 0; } $expiresTime = strtotime($this->expiresAt); $createdTime = strtotime($this->createdAt); $totalDuration = max(0, $expiresTime - $createdTime); $now = time(); $elapsedTime = max(0, $now - $createdTime); $remainingTime = max(0, $totalDuration - $elapsedTime); return ceil($remainingTime / 60); } public function getRemainingImpressions() { return $this->impressionCount - $this->currentImpressions; } public function setStatus($status) { $this->isAccepted = $status; } public function setStartDate($year, $month) { $this->startYear = $year; $this->startMonth = $month; } public function setEndDate($year, $month) { $this->endYear = $year; $this->endMonth = $month; } public function increaseImpressions($count = 1) { $this->currentImpressions += $count; if ($this->currentImpressions >= $this->impressionCount) { $this->isAccepted = self::STATUS_COMPLETED; } return $this->currentImpressions; } public function calculateCancellationPenalty() { $completionPercentage = $this->getCompletionPercentage(); if ($completionPercentage < 10) { return $this->totalCredit * 0.1; } else if ($completionPercentage < 30) { return $this->totalCredit * 0.2; } else if ($completionPercentage < 60) { return $this->totalCredit * 0.4; } else if ($completionPercentage < 90) { return $this->totalCredit * 0.6; } else { return $this->totalCredit * 0.8; } } public function isExpired($currentYear, $currentMonth) { if ($this->endYear === null || $this->endMonth === null) { return false; } if ($currentYear > $this->endYear) { return true; } elseif ($currentYear == $this->endYear && $currentMonth > $this->endMonth) { return true; } return false; } public function isPending() { return $this->isAccepted === self::STATUS_PENDING; } public function isActive() { return $this->isAccepted === self::STATUS_ACCEPTED; } public function isCompleted() { return $this->isAccepted === self::STATUS_COMPLETED; } public function save($db) { if ($this->id) { $db->query( "UPDATE ads SET
                name = ?,
                description = ?,
                type = ?,
                impression_count = ?,
                credit_per_impression = ?,
                completion_months = ?,
                start_year = ?,
                start_month = ?,
                end_year = ?,
                end_month = ?,
                is_accepted = ?,
                current_impressions = ?,
                visitor_satisfaction_effect = ?,
                expires_at = ?,
                total_credit = ?
                WHERE id = ?", [ $this->name, $this->description, $this->type, $this->impressionCount, $this->creditPerImpression, $this->completionMonths, $this->startYear, $this->startMonth, $this->endYear, $this->endMonth, $this->isAccepted, $this->currentImpressions, $this->visitorSatisfactionEffect, $this->expiresAt, $this->totalCredit, $this->id ] ); } else { $db->query( "INSERT INTO ads
                (name, description, type, impression_count, credit_per_impression,
                 completion_months, start_year, start_month, end_year, end_month,
                 is_accepted, current_impressions, visitor_satisfaction_effect, expires_at, total_credit)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [ $this->name, $this->description, $this->type, $this->impressionCount, $this->creditPerImpression, $this->completionMonths, $this->startYear, $this->startMonth, $this->endYear, $this->endMonth, $this->isAccepted, $this->currentImpressions, $this->visitorSatisfactionEffect, $this->expiresAt, $this->totalCredit ] ); $this->id = $db->lastInsertId(); } } public static function getById($db, $id) { $result = $db->query( "SELECT * FROM ads WHERE id = ?", [$id] )->fetch(PDO::FETCH_ASSOC); if ($result) { return new Ad($result); } return null; } public static function getAll($db) { $result = $db->query( "SELECT * FROM ads ORDER BY created_at DESC" )->fetchAll(PDO::FETCH_ASSOC); $ads = []; foreach ($result as $data) { $ads[] = new Ad($data); } return $ads; } public static function getPendingAds($db) { $result = $db->query( "SELECT * FROM ads WHERE is_accepted = ? ORDER BY created_at DESC", [self::STATUS_PENDING] )->fetchAll(PDO::FETCH_ASSOC); $ads = []; foreach ($result as $data) { $ads[] = new Ad($data); } return $ads; } public static function getActiveAds($db) { $result = $db->query( "SELECT * FROM ads WHERE is_accepted = ? ORDER BY created_at ASC", [self::STATUS_ACCEPTED] )->fetchAll(PDO::FETCH_ASSOC); $ads = []; foreach ($result as $data) { $ads[] = new Ad($data); } return $ads; } public static function getCompletedAds($db, $limit = null) { $sql = "SELECT * FROM ads WHERE is_accepted = ? ORDER BY created_at DESC"; $params = [self::STATUS_COMPLETED]; if ($limit !== null && is_numeric($limit) && $limit > 0) { $sql .= " LIMIT " . (int)$limit; } $result = $db->query($sql, $params)->fetchAll(PDO::FETCH_ASSOC); $ads = []; foreach ($result as $data) { $ads[] = new Ad($data); } return $ads; } public static function countPendingAds($db) { return $db->query( "SELECT COUNT(*) FROM ads WHERE is_accepted = ?", [self::STATUS_PENDING] )->fetchColumn(); } } 